<?php
include '../includes/title.inc.php';
require_once('../includes/session_timeout_db.inc.php');
require_once('../includes/connection.inc.php');
 // create database connection
$conn = dbConnect('write', 'pdo');
// initialize flags
$OK = false;
$deleted = false;
// get details of selected record
if (isset($_GET['article_id']) && !$_POST) {
  // prepare SQL query
  $sql = 'SELECT article_id, title, created FROM blog WHERE article_id = ?';
  $stmt = $conn->prepare($sql);
  // assign result array to variables
  $stmt->bindColumn(1, $article_id);
  $stmt->bindColumn(2, $title);
  $stmt->bindColumn(3, $created);
  // execute query by passing array of variables
  $OK = $stmt->execute(array($_GET['article_id']));
  // fetch the result
  $stmt->fetch();
}
// if confirm deletion button has been clicked, delete record
if (isset($_POST['delete'])) {
  $sql = 'DELETE FROM blog WHERE article_id = ?';
  $stmt = $conn->prepare($sql);
  $stmt->execute(array($_POST['article_id']));
  // get number of affected rows
  $deleted = $stmt->rowCount();
  if (!$deleted) {
	$error = 'There was a problem deleting the record.';
  }
}
// redirect the page if deleted, cancel button clicked, or $_GET['article_id'] not defined
if ($deleted || isset($_POST['cancel_delete']) || !isset($_GET['article_id']))  {
header('Location: http://localhost/projects/junior/maint/menu_db.php');
  exit;
}
?>

<html>

<head>
<!-- Basic Page Needs
  ================================================== -->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>orogutours<?php if (isset($title)) echo "&#8212;{$title}"; ?></title>
<meta name="description" content="">
<meta name="keywords" content="">
<meta name="author" content="">
<!-- Mobile Specific Metas
  ================================================== -->
<meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0">
<meta name="format-detection" content="telephone=no">
<!-- CSS
  ================================================== -->


<link href="css/index.css" rel="stylesheet" type="text/css">

<!--[if lte IE 8]><link rel="stylesheet" type="text/css" href="css/ie8.css" media="screen" /><![endif]-->
<!-- Color Style -->
<link class="alt" href="colors/color1.css" rel="stylesheet" type="text/css">

<!-- SCRIPTS
  ================================================== -->
<div class="fit-vids-style">­<style>              
                                   
</style>
</div>
<script src="../js/modernizr.js"></script><!-- Modernizr -->
</head>
<body style="background-image: none;">

<div id="wrapper">

  <div id="top_seccion">

<div style="text-align: center;"><a href="menu_db.php"><img src="../images/logo_footer.png" alt="logo"/></a></div><br />

<div style="text-align: center;">You are welcome - <?php echo $_SESSION['user']; ?></div>


<ul class="menu">

<li>
<?php include('../includes/logout_db.inc.php'); ?>
</li>

<li>
<form method="post" action="menu_db.php">
  <input class="btn" name="home" type="submit" id="home" value="Home">
</form>
</li>

</ul>
</div>




<h1>Delete Blog Entry </h1>
<?php 
if (isset($error)) {
  echo "<p class='warning'>Error: $error</p>";
} elseif (isset($article_id) && $article_id == 0) { ?>
<p class="warning">Invalid request: record does not exist.</p>
<?php } else { ?>
<p class="warning">Please confirm that you want to delete the following item. This action cannot be undone.</p>
<p><?php echo $created .': ' .htmlentities($title, ENT_COMPAT, 'utf-8'); ?></p>
<?php } ?>
<form id="form1" method="post" action="">
    <p>
	<?php if (isset($article_id) && $article_id > 0) { ?>
        <input class="btn" type="submit" name="delete" value="Confirm">
	<?php } ?>
		<input class="btn" name="cancel_delete" type="submit" id="cancel_delete" value="Cancel">
<?php if (isset($article_id) && $article_id > 0) { ?>
		<input name="article_id" type="hidden" value="<?php echo $article_id; ?>">
	<?php } ?>
    </p>
</form>

</div>
<div id="footer">

 
  <em> &copy; coded by refresh rate ltd</em>

</div>
</body>
</html>
